#pragma once

//ArduinoSTL.hには衝突回避のためにarryが無く、SPRESENSE側はイテレーターが使えないので手動実装

template <class T, size_t N>
struct inoArray {
    // Storage
    T data[N];

    static size_t length() { return N; }
    using type = T;

    // Item access
    T &operator[](size_t index) { return data[index]; }
    const T &operator[](size_t index) const { return data[index]; }

    // Iterators
    T *begin() { return &data[0]; }
    const T *begin() const { return &data[0]; }
    T *end() { return &data[N]; }
    const T *end() const { return &data[N]; }

    // Comparisons
    bool operator==(const inoArray<T, N> &rhs) const {
        if (this == &rhs)
            return true;
        for (size_t i = 0; i < N; i++)
            if ((*this)[i] != rhs[i])
                return false;
        return true;
    }
    bool operator!=(const inoArray<T, N> &rhs) const {
        return !(*this == rhs);
    }

    //Function
    
    void fill( const T& value )
    {
        for (size_t i=0;i<N ;i++) {
            data[i] = value;
        }
    }

    
};
